package zigen.plugin.db.ext.jdt.vo.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;


public class DefaultVOMappingFactory extends AbstractVOMappingFactory {

	public String getJavaType(TableColumn column) {
		return getJavaType(column.getDataType());
	}

	public String getJavaType(int type) {
		switch (type) {
		case Types.CHAR:
		case Types.VARCHAR:
		case Types.LONGVARCHAR:
			return "String"; //$NON-NLS-1$

		case Types.NUMERIC:
		case Types.DECIMAL:
			return "java.math.BigDecimal"; //$NON-NLS-1$

		case Types.BIT:
			return "boolean"; //$NON-NLS-1$

		case Types.TINYINT:
			return "byte"; //$NON-NLS-1$

		case Types.SMALLINT:
			return "short"; //$NON-NLS-1$

		case Types.INTEGER:
			return "int"; //$NON-NLS-1$

		case Types.BIGINT:
			return "long"; //$NON-NLS-1$

		case Types.REAL:
			return "float"; //$NON-NLS-1$

		case Types.FLOAT:
		case Types.DOUBLE:
			return "double"; //$NON-NLS-1$

		case Types.BINARY:
		case Types.VARBINARY:
		case Types.LONGVARBINARY:
			return "byte[]"; //$NON-NLS-1$

		case Types.TIME:
			return "java.sql.Time"; //$NON-NLS-1$

		case Types.DATE:
			return "java.sql.Date"; //$NON-NLS-1$

		case Types.TIMESTAMP:
			return "java.sql.Timestamp"; //$NON-NLS-1$

		case Types.CLOB:
		case Types.BLOB:
		case Types.OTHER:
			return "Object"; //$NON-NLS-1$

		default:
			return "<<???>>"; //$NON-NLS-1$
		}
	}

}